import javax.media.j3d.*;
import javax.media.j3d.*;
import javax.vecmath.*; 
import java.awt.*;
import java.awt.event.*;
import com.sun.j3d.utils.image.*;
import com.sun.j3d.utils.geometry.*;
/**
 * This demonstrates the simple application of textures.
 * Each face of a cube has an image mapped onto it 
 * exactly once.  The image is loaded from an external file.
 * @author I.J.Palmer
 * @version 1.0
 */ 
public class SimpleTexture extends Frame implements ActionListener {
    protected Canvas3D myCanvas3D = new Canvas3D(null);
    protected Button myButton = new Button("Exit");
    /**
     * This function builds the view branch of the scene
     * graph.  It creates a branch group and then creates the
     * necessary view elements to give a useful view of our
     * content.
     * @param c Canvas3D that will display the view
     * @return BranchGroup that is the root of the view elements
     */
    protected BranchGroup buildViewBranch(Canvas3D c) {
		BranchGroup viewBranch = new BranchGroup();
		Transform3D viewXfm = new Transform3D();
            viewXfm.set(new Vector3f(0.0f,0.0f,5.0f));
		TransformGroup viewXfmGroup = new TransformGroup(viewXfm);
		ViewPlatform myViewPlatform = new ViewPlatform();
            PhysicalBody myBody = new PhysicalBody();
            PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
		viewXfmGroup.addChild(myViewPlatform);
		viewBranch.addChild(viewXfmGroup);
		View myView = new View();
		myView.addCanvas3D(c);
		myView.attachViewPlatform(myViewPlatform);
            myView.setPhysicalBody(myBody);
            myView.setPhysicalEnvironment(myEnvironment);
		return viewBranch;
	}
    /**
     * Add some lights so that we can illuminate the scene.
     * This adds one ambient light to bring up the overall 
     * lighting level and one directional shape to show
     * the shape of the objects in the scene.
     * @param b BranchGroup that the lights are to be added to.
     */
    protected void addLights(BranchGroup b) {
                BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
                Color3f lightColour1 = new Color3f(1.0f,1.0f,1.0f);
                Vector3f lightDir1  = new Vector3f(-1.0f, -1.0f,-1.0f);
                Color3f lightColour2 = new Color3f(1.0f, 1.0f, 1.0f);
                Vector3f lightDir2  = new Vector3f(0.0f, 0.0f, -1.0f);
                Color3f ambientColour = new Color3f(0.2f, 0.2f, 0.2f);
                AmbientLight ambientLight1 = new AmbientLight(ambientColour);
                ambientLight1.setInfluencingBounds(bounds);
                DirectionalLight directionalLight1 = new DirectionalLight(lightColour1, lightDir1);
                directionalLight1.setInfluencingBounds(bounds);
                b.addChild(ambientLight1);
                b.addChild(directionalLight1);
        }
    /**
     * This builds the content branch of our scene graph.
     * The shape supplied as a parameter
     * is slightly tilted to reveal its 3D shape. It also uses
     * the addLights function to add some lights to the scene.
     * @param shape Node that represents the geometry for the content
     * @return BranchGroup that is the root of the content branch
     */
      protected BranchGroup buildContentBranch(Node shape) {
		BranchGroup contentBranch = new BranchGroup();
		Transform3D rotateCube = new Transform3D( );
            rotateCube.set(new AxisAngle4d(1.0,1.0,0.0,Math.PI/4.0));
		TransformGroup rotationGroup = new TransformGroup(rotateCube);
		contentBranch.addChild(rotationGroup);
            rotationGroup.addChild(shape);
            addLights(contentBranch);
		return contentBranch;
      } 
    /** 
     * This defines the appearance with a texture.
     * The texture is loaded from an external file.
     * @return Appearance that uses the texture.
     */
     protected Appearance DefineAppearance() {
        //Load the texture from the external image file
        TextureLoader textLoad = new TextureLoader("housebrick.jpg", this);
        //Access the image from the loaded texture
        ImageComponent2D textImage = textLoad.getImage();
        //Create a two dimensional texture 
        Texture2D texture = new Texture2D(Texture2D.BASE_LEVEL, Texture.RGB, 
								textImage.getWidth(), textImage.getHeight());
        //Set the texture from the image loaded
        texture.setImage(0, textImage);
        //Create the appearance that will use the texture
        Appearance app = new Appearance();
        app.setTexture(texture);
        //Define how the texture will be mapped onto the surface
        //by creating the appropriate texture attributes
        TextureAttributes textAttr = new TextureAttributes();
        textAttr.setTextureMode(TextureAttributes.REPLACE);
        app.setTextureAttributes(textAttr);
        app.setMaterial(new Material());
        return app;
    }
    /**
     * Build a cube from an IndexedQuadArray.  This method creates
     * the vertices as a set of eight points and the normals as a set of 
     * six vectors (one for each face).  The data is then defined such
     * that each vertex has a different normal associated with it when 
     * it is being used for a different face.  The shape is created with
     * texture coordinates so that when the appearance is set it will
     * use the appearance texture on the surface.
     * @return Node that is the shape.
     */
     protected Node buildShape() {
        IndexedQuadArray indexedCube = new IndexedQuadArray(8,
                                             IndexedQuadArray.COORDINATES|
                                             IndexedQuadArray.NORMALS|
                                             IndexedQuadArray.TEXTURE_COORDINATE_2, 24);
        Point3f[] cubeCoordinates = { new Point3f( 1.0f, 1.0f, 1.0f),
							new Point3f(-1.0f, 1.0f, 1.0f),
							new Point3f(-1.0f,-1.0f, 1.0f),
							new Point3f( 1.0f,-1.0f, 1.0f),
							new Point3f( 1.0f, 1.0f,-1.0f),
							new Point3f(-1.0f, 1.0f,-1.0f),
							new Point3f(-1.0f,-1.0f,-1.0f),
							new Point3f( 1.0f,-1.0f,-1.0f)};
        Vector3f[] normals= {new Vector3f( 0.0f, 0.0f, 1.0f),
                       new Vector3f( 0.0f, 0.0f,-1.0f),
                       new Vector3f( 1.0f, 0.0f, 0.0f),
                       new Vector3f(-1.0f, 0.0f, 0.0f),
                       new Vector3f( 0.0f, 1.0f, 0.0f),
                       new Vector3f( 0.0f,-1.0f, 0.0f)};
        //Define the texture coordinates.  These are defined
        //as floating point pairs of values that are used to 
        //map the corners of the texture image onto the vertices
        //of the face.  We then define the indices into this
        //array of values in a similar way to that used for
        //the vertices and normals.
        TexCoord2f[] textCoord = {	new TexCoord2f(1.0f,1.0f),
							new TexCoord2f(0.0f,1.0f),
							new TexCoord2f(0.0f,0.0f),
							new TexCoord2f(1.0f,0.0f)};
        int coordIndices[] =  {0,1,2,3,7,6,5,4,0,3,7,4,5,6,2,1,0,4,5,1,6,7,3,2};
        int normalIndices[] = {0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5};
        int textIndices[] =   {0,1,2,3,3,0,1,2,1,2,3,0,1,2,3,0,3,0,1,2,1,2,3,0};
        indexedCube.setCoordinates(0, cubeCoordinates);
		indexedCube.setCoordinateIndices(0, coordIndices);
		indexedCube.setNormals(0,normals);
		indexedCube.setNormalIndices(0, normalIndices);
		indexedCube.setTextureCoordinates(0,0,textCoord);
		indexedCube.setTextureCoordinateIndices(0,0,textIndices);
		return new Shape3D(indexedCube, DefineAppearance());
	}
    /**
     * Handles the exit button action to quit the program.
     */
    public void actionPerformed(ActionEvent e) {
        dispose();
        System.exit(0);
    }
        public SimpleTexture() {
		VirtualUniverse myUniverse = new VirtualUniverse();
		Locale myLocale = new Locale(myUniverse);
                myLocale.addBranchGraph(buildViewBranch(myCanvas3D));
                myLocale.addBranchGraph(buildContentBranch(buildShape()));
		setTitle("SimpleTexture");
		setSize(400,400);
		setLayout(new BorderLayout());
                add("Center", myCanvas3D);
                add("South",myButton);
                myButton.addActionListener(this);
                setVisible(true);
	}
	public static void main(String[] args) {
                  SimpleTexture st = new SimpleTexture();
	}
}
